<?php $__env->startSection('title','CARRISOFT V2: BON DE COMMANDE'); ?>


<?php $__env->startSection('content'); ?>
    <main class="col-sm-12 ml-sm-auto col-md-12 pt-0" style="text-decoration: none; margin-top: 5px;">
        <div class="col-12 col-sm-12 col-md-12">
            <h3 class="ml-5"><?php echo e(__('messages.FICHE DE STOCK')); ?></h3>
            
        </div>
        <br>

        <div class="info-box mb-1">
            <div class="row col-md-12">
                <div class="col-12 col-md-3">
                    <label>Du</label>
                    <input type="date" name="from_date" id="from_date" class="form-control"  />
                </div>
                <div class="col-12 col-md-3">
                    <label>Au</label>
                    <input type="date" name="to_date" id="to_date" class="form-control" />
                </div>
                <div class="cool-md-3 float-left">
                    <label>Produit</label>
                    <select name="produit_id" id="produit_id" class="form-control">
                        <?php $__currentLoopData = $produits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$produit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value= "<?php echo $produit; ?>"> <?php echo $produit; ?> </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <div class="col-12 col-md-3">
                    <button type="button" name="filter" id="filter" class="btn btn-danger"><?php echo e(__('messages.Rechercher')); ?></button>
                    <button type="button" name="imprimer" id="imprimer" class="btn btn-primary"><?php echo e(__('messages.Imprimer')); ?></button>
                </div>

            </div>
            <!-- /.info-box-content -->
        </div>

        <div class="col-md-12">
            <div class="info-box">
                <div class="table-responsive">
                    <table class="table table-striped table-bordered" id="fiche_produit">
                        <thead>
                        <tr class="cart_menu">
                            <td class="price"><?php echo e(__('messages.Date')); ?></td>
                            <td class="price"><?php echo e(__('messages.Libelle')); ?></td>
                            <td class="price"><?php echo e(__('messages.Initial')); ?></td>
                            <td class="price"><?php echo e(__('messages.Achat')); ?></td>
                            <td class="price"><?php echo e(__('messages.Sortie')); ?></td>
                            <td class="total"><?php echo e(__('messages.Solde')); ?></td>
                        </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>

    </main>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('extra-js'); ?>
    <script>
        function produit() {
            $.ajax({
                url:"inv.produits",
                dataType:"json",
                success:function(data)
                {
                    $('#produit_id').empty();
                    $('#produit_id').append('<option id="0"  value="0">- <?php echo e(__('messages.Choisir un produit')); ?> -</option>');
                    for (var i = 0; i < data.length; i++) {
                        $('#produit_id').append('<option id=' + data[i].produit_id + ' value=' + data[i].produit_id + '>'+ data[i].libelle +'</option>');
                    }
                    $('#produit_id').change();
                }
            })
        }

        function actualiser() {
            produit_id = document.getElementById("produit_id").value;
        }

        $(document).ready(function(){
            $('.input-daterange').datepicker({
                todayBtn:'linked',
                format:'yyyy-mm-dd',
                autoclose:true
            });
            produit()

            load_data();

            function load_data(from_date = '', to_date = '', produit_id=0) {
                $('#fiche_produit').DataTable({
                    processing: true,
                    serverSide: true,
                    ajax: {
                        url:'<?php echo e(route("inv.invproduit")); ?>',
                        data:{from_date:from_date, to_date:to_date, produit_id:produit_id}
                    },
                    columns: [
                        {
                            data:'date',
                            name:'date'
                        },
                        {
                            data:'motif',
                            name:'motif'
                        },
                        {
                            data:'qte_initiale',
                            name:'qte_initiale'
                        },
                        {
                            data:'qte_entree',
                            name:'qte_entree'
                        },
                        {
                            data:'qte_sortie',
                            name:'qte_sortie'
                        },
                        {
                            data:'qte_reelle',
                            name:'qte_reelle'
                        }

                    ]
                });
            }

            $('#filter').click(function(){
                var from_date = $('#from_date').val();
                var to_date = $('#to_date').val();
                var produit_id = $('#produit_id').val();
                if(from_date != '' && to_date != '')
                {
                    $('#fiche_produit').DataTable().destroy();
                    load_data(from_date, to_date,produit_id);
                }
                else
                {
                    alert('<?php echo e(__('messages.Selectionner la periode')); ?>');
                }
            });

            $('#reset').click(function(){
                $('#from_date').val('');
                $('#to_date').val('');
                $('#inventaires').DataTable().destroy();
                load_data();
            });

            $('#imprimer').click(function(){
                var debut = document.getElementById('from_date').value;
                var fin = document.getElementById('to_date').value;
                var produit_id = document.getElementById('produit_id').value;
                console.log(debut,fin,produit_id)

                var newWin = window.open();
                var the_url = "inv.print_invproduit/"+debut+"/"+fin+"/"+produit_id;
                $.ajax({
                    type: "GET", url: the_url, data: {},
                    success: function(data){
                        newWin.document.write(data);;
                    }
                    ,error: function() {
                    }
                });
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.adminlayout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\gas_online\resources\views/inventaire/invproduit.blade.php ENDPATH**/ ?>